#!/bin/bash

# 循环n从1到20
for n in {1..20}; do
    echo "Processing n = $n..."
    
    # 检查必要的文件是否存在
    if [[ ! -f "STRU_HEAD" ]]; then
        echo "Error: STRU_HEAD file not found in current directory!" >&2
        exit 1
    fi
    if [[ ! -f "5/output_files/output_${n}.txt" ]]; then
        echo "Error: output_${n}.txt not found in 5/output_files/!" >&2
        exit 1
    fi

    # 连接文件生成STRU
    cat STRU_HEAD "5/output_files/output_${n}.txt" > STRU
    
    # 运行ABACUS计算
    echo "Running ABACUS calculation for n=$n..."
    OMP_NUM_THREADS=1 mpirun abacus
    
    # 检查计算是否成功
    if [[ $? -ne 0 ]]; then
        echo "Error: ABACUS calculation failed for n=$n!" >&2
        exit 1
    fi
    
    # 重命名输出目录
    if [[ -d "OUT.ABACUS" ]]; then
        mv "OUT.ABACUS" "OUT.${n}"
        echo "Output saved to OUT.${n}"
    else
        echo "Error: OUT.ABACUS directory not found after calculation!" >&2
        exit 1
    fi
    
    # 清理STRU文件
    rm -f STRU
    echo "Cleaned up STRU file"
    
    echo "----------------------------------------"
done

echo "All calculations completed successfully!"
